<?php

use App\Http\Controllers\api\CustomerController;
use App\Http\Controllers\api\InbondController;
use App\Http\Controllers\api\InbondDetailController;
use App\Http\Controllers\api\InbondSubDetailController;
use App\Http\Controllers\api\LoginController;
use App\Http\Controllers\api\MaterialController;
use App\Http\Controllers\api\RegionController;
use App\Http\Controllers\api\RegisterController;
use App\Http\Controllers\api\PasienController;
use App\Http\Controllers\api\BukuKehidupanController;
use App\Http\Controllers\api\HidupSehatController;
use App\Http\Controllers\api\KeluhanTindakanController;
use App\Http\Controllers\api\KunjunganPasienController;
use App\Http\Controllers\api\LivingCareController;
use App\Http\Controllers\api\ReportController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post("login",[LoginController::class, 'login']);
Route::post("register",[RegisterController::class, 'register']);

Route::get('pasien/{id}', [PasienController::class, 'show']);
Route::post('pasien', [PasienController::class, 'store']);
Route::put('pasien/{id}', [PasienController::class, 'update']);
Route::delete('pasien/{id}', [PasienController::class, 'delete']);

Route::get('buku-kehidupan/{id}', [BukuKehidupanController::class, 'show']);
Route::post('buku-kehidupan', [BukuKehidupanController::class, 'store']);
Route::put('buku-kehidupan/{id}', [BukuKehidupanController::class, 'update']);
Route::delete('buku-kehidupan/{id}', [BukuKehidupanController::class, 'delete']);

Route::get('hidup-sehat/{id}', [HidupSehatController::class, 'show']);
Route::post('hidup-sehat', [HidupSehatController::class, 'store']);
Route::put('hidup-sehat/{id}', [HidupSehatController::class, 'update']);
Route::delete('hidup-sehat/{id}', [HidupSehatController::class, 'delete']);

Route::get('keluhan-tindakan/{id}', [KeluhanTindakanController::class, 'show']);
Route::post('keluhan-tindakan', [KeluhanTindakanController::class, 'store']);
Route::put('keluhan-tindakan/{id}', [KeluhanTindakanController::class, 'update']);
Route::delete('keluhan-tindakan/{id}', [KeluhanTindakanController::class, 'delete']);

Route::get('kunjungan-pasien/{id}', [KunjunganPasienController::class, 'show']);
Route::post('kunjungan-pasien', [KunjunganPasienController::class, 'store']);
Route::put('kunjungan-pasien/{id}', [KunjunganPasienController::class, 'update']);
Route::delete('kunjungan-pasien/{id}', [KunjunganPasienController::class, 'delete']);

Route::get('living-care/{id}', [LivingCareController::class, 'show']);
Route::post('living-care', [LivingCareController::class, 'store']);
Route::put('living-care/{id}', [LivingCareController::class, 'update']);
Route::delete('living-care/{id}', [LivingCareController::class, 'delete']);

Route::get('report/{id}', [ReportController::class, 'report']);