
<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Invoice - #123</title>

    <style type="text/css">
        @page {
            margin: 0px;
        }
        body {
            margin: 20px;
        }
        * {
            font-family: Verdana, Arial, sans-serif;
        }
        a {
            color: #fff;
            text-decoration: none;
        }
        table {
            font-size: small;
        }
        tfoot tr td {
            font-weight: bold;
            font-size: x-small;
        }
        td h3 {
            margin: 0px 0px 5px 0px;
        }
        td h4 {
            margin: 0px;
        }
        td p {
            margin-top: 0px;
            margin-bottom: 0px;
        }
        .kms-title {
            margin-left : 20px;
        }
        .kms-true {
            margin-left : 40px;
        }
        .kms-false {
            color : #DDDDDD;
            margin-left : 40px;
        }
        .invoice {
            padding: 0px 30px 20px 30px;
        }
        .information {
            padding: 30px 30px 20px 30px;
            background-color: #60A7A6;
            color: #FFF;
        }
        .information .logo {
            border-radius: 32px;
        }
        .footer {
            padding: 10px 30px 10px 30px;
            background-color: #60A7A6;
            color: #FFF;
        }
    </style>

</head>
<body>

<div class="information">
    @if($pasien->path_foto)
        <img src="{{ public_path().'/'.$pasien->path_foto }}" width="64" class="logo"/>
    @endif
    <table width="100%">
        <td width="25%">
            <p>Nama</p>
            <p>Tempat, tanggal lahir</p>
            <p>Alamat</p>
            <p>Pendidikan</p>
            <p>Pekerjaan</p>
            <p>Status</p>
        </td>
        <td width="10px">
            <p>:</p>
            <p>:</p>
            <p>:</p>
            <p>:</p>
            <p>:</p>
            <p>:</p>
        </td>
        <td>
            <p>{{ $pasien->nama }}</p>
            <p>{{ $pasien->tempat_lahir.", ".$pasien->tanggal_lahir }}</p>
            <p>{{ $pasien->alamat }}</p>
            <p>{{ $pasien->pendidikan }}</p>
            <p>{{ $pasien->pekerjaan }}</p>
            <p>{{ $pasien->status }}</p>
        </td>
    </table>
</div>

<div class="invoice">
    <h3 style="margin-left: -17px">I. Buku Kehidupan</h3>
    <table width="100%">
        <tr>
            <td width="50%">
                <h3>1. Pengantar hidup</h3>
                @php
                    $jArr = json_decode($bukukehidupan->pengantar_hidup);
                @endphp
                @if ($jArr)
                    @foreach ($jArr as $data)
                        <p>{{ $data->label }} : {{ $data->value }}</p>
                    @endforeach
                @else
                    <p>Tidak ada data</p>
                @endif
            </td>
            <td>
                <h3>2. Masa kecilku</h3>
                @php
                    $jArr = json_decode($bukukehidupan->masa_kecil);
                @endphp
                @if ($jArr)
                    @foreach ($jArr as $data)
                        <p>{{ $data->label }} : {{ $data->value }}</p>
                    @endforeach
                @else
                    <p>Tidak ada data</p>
                @endif
            </td>
        </tr>

        <tr>
            <td width="50%">
                <h3>3. Pekerjaaku</h3>
                @php
                    $jArr = json_decode($bukukehidupan->pekerjaan);
                @endphp
                @if ($jArr)
                    @foreach ($jArr as $data)
                        <p>{{ $data->label }} : {{ $data->value }}</p>
                    @endforeach
                @else
                    <p>Tidak ada data</p>
                @endif
            </td>
            <td>
                <h3>4. Relasi penting</h3>
                @php
                    $jArr = json_decode($bukukehidupan->relasi_penting);
                @endphp
                @if ($jArr)
                    @foreach ($jArr as $data)
                        <p>{{ $data->label }} : {{ $data->value }}</p>
                    @endforeach
                @else
                    <p>Tidak ada data</p>
                @endif
            </td>
        </tr>

        <tr>
            <td width="50%">
                <h3>5. Tempat-tempat penting</h3>
                @php
                    $jArr = json_decode($bukukehidupan->tempat_penting);
                @endphp
                @if ($jArr)
                    @foreach ($jArr as $data)
                        <p>{{ $data->label }} : {{ $data->value }}</p>
                    @endforeach
                @else
                    <p>Tidak ada data</p>
                @endif
            </td>
            <td>
                <h3>6. Kegiatan sosial dan minat</h3>
                @php
                    $jArr = json_decode($bukukehidupan->kegiatan_sosial);
                @endphp
                @if ($jArr)
                    @foreach ($jArr as $data)
                        <p>{{ $data->label }} : {{ $data->value }}</p>
                    @endforeach
                @else
                    <p>Tidak ada data</p>
                @endif
            </td>
        </tr>

        <tr>
            <td width="50%">
                <h3>7. Peristiwa hidup yang berarti</h3>
                @php
                    $jArr = json_decode($bukukehidupan->peristiwa_hidup);
                @endphp
                @if ($jArr)
                    @foreach ($jArr as $data)
                        <p>{{ $data->label }} : {{ $data->value }}</p>
                    @endforeach
                @else
                    <p>Tidak ada data</p>
                @endif
            </td>
            <td>
                <h3>8. Pensiun</h3>
                @php
                    $jArr = json_decode($bukukehidupan->pensiun);
                @endphp
                @if ($jArr)
                    @foreach ($jArr as $data)
                        <p>{{ $data->label }} : {{ $data->value }}</p>
                    @endforeach
                @else
                    <p>Tidak ada data</p>
                @endif
            </td>

            <tr>
            <td width="50%">
                <h3>9. Kehidupanku sekarang</h3>
                @php
                    $jArr = json_decode($bukukehidupan->kehidupan_sekarang);
                @endphp
                @if ($jArr)
                    @foreach ($jArr as $data)
                        <p>{{ $data->label }} : {{ $data->value }}</p>
                    @endforeach
                @else
                    <p>Tidak ada data</p>
                @endif
            </td>
            <td>
                <h3>10. Penampilanku</h3>
                @php
                    $jArr = json_decode($bukukehidupan->penampilan);
                @endphp
                @if ($jArr)
                    @foreach ($jArr as $data)
                        <p>{{ $data->label }} : {{ $data->value }}</p>
                    @endforeach
                @else
                    <p>Tidak ada data</p>
                @endif
            </td>
        </tr>

        <tr>
            <td width="50%">
                <h3>11. Minat dan hobi</h3>
                @php
                    $jArr = json_decode($bukukehidupan->minat_hobi);
                @endphp
                @if ($jArr)
                    @foreach ($jArr as $data)
                        <p>{{ $data->label }} : {{ $data->value }}</p>
                    @endforeach
                @else
                    <p>Tidak ada data</p>
                @endif
            </td>
            <td>
                <h3>12. hal yang kusuka dan tidak kusuka</h3>
                @php
                    $jArr = json_decode($bukukehidupan->suka_tidaksuka);
                @endphp
                @if ($jArr)
                    @foreach ($jArr as $data)
                        <p>{{ $data->label }} : {{ $data->value }}</p>
                    @endforeach
                @else
                    <p>Tidak ada data</p>
                @endif
            </td>

            <tr>
            <td width="50%">
                <h3>13. Orang penting bagi saya sekarang</h3>
                @php
                    $jArr = json_decode($bukukehidupan->orang_penting);
                @endphp
                @if ($jArr)
                    @foreach ($jArr as $data)
                        <p>{{ $data->label }} : {{ $data->value }}</p>
                    @endforeach
                @else
                    <p>Tidak ada data</p>
                @endif
            </td>
            <td>
                <h3>14. Harapan untuk pelayanan kedepan</h3>
                @php
                    $jArr = json_decode($bukukehidupan->harapan);
                @endphp
                @if ($jArr)
                    @foreach ($jArr as $data)
                        <p>{{ $data->label }} : {{ $data->value }}</p>
                    @endforeach
                @else
                    <p>Tidak ada data</p>
                @endif
            </td>
        </tr>
    </table>
</div>

<div class="invoice">
    <h3 style="margin-left: -17px">II. Kartu Menuju Sehat (KMS)</h3>
    <table width="100%">
        <tr>
            <td width="50%">
                <h3>1. Anjuran untuk hidup sehat</h3>
                @php
                    $jArr = json_decode($hidupsehat->data);
                @endphp
                @if ($jArr)
                    @foreach ($jArr as $data)
                        @if ($data->title)
                            <h4 class="kms-title">{{ $data->title }}</h4>
                            @foreach ($data->data as $sub)
                                @if ($sub->value)
                                    <p class="kms-true">{{ $sub->name }}</p>
                                @else
                                    <p class="kms-false">{{ $sub->name }}</p>
                                @endif
                            @endforeach
                        @else
                            @foreach ($data->data as $sub)
                                @if ($sub->value)
                                    <h4 class="kms-title">{{ $sub->name }}</h4>
                                @else
                                    <h4 style="color: #DDDDDD" class="kms-title">{{ $sub->name }}</h4>
                                @endif
                            @endforeach
                        @endif
                    @endforeach
                @else
                    <p>Tidak ada data</p>
                @endif
            </td>
            <td>
                <h3>2. Catatan keluhan dan tindakan</h3>
                @if (count($keluhantindakan) > 0)
                    @foreach ($keluhantindakan as $data)
                        <h4 class="kms-title">{{ $data->created_at }}</h4>
                        <p class="kms-true">Keluhan : {{ $data->keluhan }}</p>
                        <p class="kms-true">Tindakan : {{ $data->tindakan }}</p>
                    @endforeach
                @else
                    <p>Tidak ada data</p>
                @endif
            </td>
        </tr>
    </table>

    <h4 style="margin: 4px">3. Kunjungan pasien</h4>
    <table style="margin-left: 25px">
        @if (count($kunjunganpasien) > 0)
            @foreach ($kunjunganpasien as $data)
                @if ($loop->index%3 == 0 || $loop->index == 0)
                <tr>
                @endif
                    <td>
                        <h4>Kunjungan ke {{$loop->index+1}}</h4>
                        <p>{{ $data->created_at }}</p>
                        @php
                            $jArr = json_decode($data->data);
                        @endphp
                        @foreach ($jArr as $sub)
                            <p>{{ $sub->label }} : 
                                @if ($sub->value)
                                    {{ $sub->value }}
                                @else
                                    -
                                @endif
                                </p>
                        @endforeach
                    </td>
            @endforeach
        @else
            <tr>
                <p>Tidak ada data</p>
            </tr>
        @endif
    </table>
</div>

<div class="invoice">
    <h3 style="margin-left: -17px">III. Living Care</h3>
    <table width="100%">
        <tr>
            <td width="50%">
                <h3>Domain 1 : Perawatan lingkungan</h3>
                @if ($livingcare)
                    @if ($livingcare->domain1)
                        @php
                            $jArr = json_decode($livingcare->domain1);
                        @endphp
                        @foreach ($jArr as $data)
                            <h4>{{ $data->label }}</h4>
                            @if ($data->value)
                                <p style="white-space: pre-line" class="kms-title">{{ $data->value }}</p>
                            @else
                                <p class="kms-title">-</p>
                            @endif
                        @endforeach
                    @else
                        <p>Tidak ada data</p>
                    @endif
                @else
                    <p>Tidak ada data</p>
                @endif
            </td>

            <td width="50%">
                <h3>Domain 2 : Partisipasi</h3>
                @if ($livingcare)
                    @if ($livingcare->domain2)
                        @php
                            $jArr = json_decode($livingcare->domain2);
                        @endphp
                        @foreach ($jArr as $data)
                            <h4>{{ $data->label }}</h4>
                            @if ($data->value)
                                <p style="white-space: pre-line" class="kms-title">{{ $data->value }}</p>
                            @else
                                <p class="kms-title">-</p>
                            @endif
                        @endforeach
                    @else
                        <p>Tidak ada data</p>
                    @endif
                @else
                    <p>Tidak ada data</p>
                @endif
            </td>
        </tr>

        <tr>
            <td width="50%">
                <h3>Domain 3 : Kesejahteraan</h3>
                @if ($livingcare)
                    @if ($livingcare->domain3)
                        @php
                            $jArr = json_decode($livingcare->domain3);
                        @endphp
                        @foreach ($jArr as $data)
                            <h4>{{ $data->label }}</h4>
                            @if ($data->value)
                                <p style="white-space: pre-line" class="kms-title">{{ $data->value }}</p>
                            @else
                                <p class="kms-title">-</p>
                            @endif
                        @endforeach
                    @else
                        <p>Tidak ada data</p>
                    @endif
                @else
                    <p>Tidak ada data</p>
                @endif
            </td>

            <td width="50%">
                <h3>Domain 4 : Health and care</h3>
                @if ($livingcare)
                    @if ($livingcare->domain4)
                        @php
                            $jArr = json_decode($livingcare->domain4);
                        @endphp
                        @foreach ($jArr as $data)
                            <h4>{{ $data->label }}</h4>
                            @if ($data->value)
                                <p style="white-space: pre-line" class="kms-title">{{ $data->value }}</p>
                            @else
                                <p class="kms-title">-</p>
                            @endif
                        @endforeach
                    @else
                        <p>Tidak ada data</p>
                    @endif
                @else
                    <p>Tidak ada data</p>
                @endif
            </td>
        </tr>
    </table>
</div>

<div class="footer" style="position: absolute; bottom: 0;">
    <table width="100%">
        <tr>
            <td align="left" style="width: 50%;">
                &copy; {{ date('Y') }} {{ config('app.url') }} - All rights reserved.
            </td>
            <td align="right" style="width: 50%;">
                Company Slogan
            </td>
        </tr>

    </table>
</div>
</body>
</html>