<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePasiensTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pasiens', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("id_perawat")->nullable();
            $table->foreign("id_perawat")->references("id")->on("perawats");
            $table->string('nama',100);
            $table->date('tanggal_lahir');
            $table->string('tempat_lahir',100);
            $table->string('alamat',100);
            $table->string('pendidikan',10);
            $table->string('pekerjaan',100);
            $table->string('status',50);
            $table->text('path_foto');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pasiens');
    }
}
