<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SendMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($nama, $kode)
    {
        $this->nama = $nama;
        $this->kode = $kode;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from('sipplink.sumselprov@gmail.com')
            ->view('email')
            ->with(
            [
                'nama' => $this->nama,
                'kode' => $this->kode
            ]);
    }
} 